/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.config.data.CfgItemGame;
import frc.emul.util.BinaryPersistenceHeader;
import frc.emul.util.Utils;
import frc.util.BytesArrayOutputStream;
import frc.util.IntStack;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryPersistenceWriter
implements IPersistenceWriter {
    private final List<IPersistentSection> sections = new ArrayList<IPersistentSection>();
    private final IntStack offsets = new IntStack();
    private final byte[] workBuff = new byte[8];
    private OutputStream out;
    private BytesArrayOutputStream buffOut = new BytesArrayOutputStream(16384);
    private OutputStream fileOut;

    public static BinaryPersistenceWriter open(BinaryPersistenceHeader binaryPersistenceHeader, CfgItemGame cfgItemGame, File file) throws PersistenceException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception exception) {
            throw new PersistenceException("File-System", "Could not create the specified save file.", exception);
        }
        BinaryPersistenceWriter binaryPersistenceWriter = new BinaryPersistenceWriter(binaryPersistenceHeader, fileOutputStream);
        try {
            binaryPersistenceHeader.storeHeader(cfgItemGame, binaryPersistenceWriter);
            if (binaryPersistenceHeader.isCompressed()) {
                binaryPersistenceWriter.compressOutputStream();
            }
        }
        catch (PersistenceException persistenceException) {
            try {
                binaryPersistenceWriter.close();
            }
            catch (Exception exception) {}
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {}
            throw persistenceException;
        }
        return binaryPersistenceWriter;
    }

    private BinaryPersistenceWriter(BinaryPersistenceHeader binaryPersistenceHeader, OutputStream outputStream) {
        this.fileOut = outputStream;
        this.out = outputStream;
    }

    static String getCurrentSectionPath(List<IPersistentSection> list) {
        block5: {
            if (!list.isEmpty()) break block5;
            return "ROOT";
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(40);
            for (IPersistentSection iPersistentSection : list) {
                String string;
                if (iPersistentSection == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append((string = iPersistentSection.getTag()) != null ? string : BinaryPersistenceWriter.getSectionID(iPersistentSection));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "inconsistent";
        }
    }

    public static String getSectionID(IPersistentSection iPersistentSection) {
        return iPersistentSection == null ? "null" : "$" + Utils.HEX4(iPersistentSection.getID());
    }

    private String getCurrentSectionPath() {
        return BinaryPersistenceWriter.getCurrentSectionPath(this.sections);
    }

    private void compressOutputStream() throws PersistenceException {
        if (!(this.fileOut instanceof GZIPOutputStream)) {
            try {
                this.fileOut.flush();
                this.fileOut = new GZIPOutputStream(this.fileOut);
                if (this.out != this.buffOut) {
                    this.out = this.fileOut;
                }
            }
            catch (Exception exception) {
                if (this.fileOut != null) {
                    try {
                        this.fileOut.close();
                    }
                    catch (Exception exception2) {}
                }
                throw new PersistenceException("File-Header", "Failed to create a compressed output stream for the save file.", exception);
            }
        }
    }

    private void emitByte(int n) throws PersistenceException {
        try {
            this.out.write(n);
        }
        catch (IOException iOException) {
            String string = this.getCurrentSectionPath();
            throw new PersistenceException(string, "Error while writing to the save output file.", iOException);
        }
    }

    @Override
    public void close() throws PersistenceException {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            throw new PersistenceException("File-System", "Could not close the save output file.", iOException);
        }
    }

    @Override
    public void closeSection() throws PersistenceException {
        IPersistentSection iPersistentSection = null;
        try {
            iPersistentSection = this.sections.remove(this.sections.size() - 1);
            int n = this.offsets.pop();
            int n2 = this.buffOut.getCurrentOffset();
            int n3 = n2 - n;
            byte[] byArray = this.buffOut.getCurrentContent();
            byArray[n - 2] = (byte)(n3 >> 8);
            byArray[n - 1] = (byte)n3;
            if (n3 >= 65280) {
                n2 += 2;
                this.buffOut.insert(2, n - 2);
                byArray = this.buffOut.getCurrentContent();
                byArray[n - 2] = -1;
                byArray[n - 1] = (byte)(n3 >> 16);
            }
            if (this.offsets.isEmpty()) {
                this.out = this.fileOut;
                this.write(byArray, 0, n2);
                this.buffOut.reset();
            }
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            PersistenceException persistenceException = new PersistenceException(this.getCurrentSectionPath(), "Error while writing into the save file.", exception);
            persistenceException.setDetails("closing section " + BinaryPersistenceWriter.getSectionID(iPersistentSection));
            throw persistenceException;
        }
    }

    @Override
    public void openSection(IPersistentSection iPersistentSection) throws PersistenceException {
        try {
            this.sections.add(iPersistentSection);
            this.out = this.buffOut;
            this.write(iPersistentSection.getID() << 16);
            this.offsets.push(this.buffOut.getCurrentOffset());
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            PersistenceException persistenceException = new PersistenceException(this.getCurrentSectionPath(), "Error while writing into the save file.", exception);
            persistenceException.setDetails("opening section " + BinaryPersistenceWriter.getSectionID(iPersistentSection));
            throw persistenceException;
        }
    }

    @Override
    public void write(IPersistentObject iPersistentObject) throws PersistenceException {
        IPersistentSection iPersistentSection = iPersistentObject.getSection();
        if (iPersistentSection != null) {
            this.openSection(iPersistentSection);
        }
        try {
            iPersistentObject.store(this);
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            PersistenceException persistenceException = new PersistenceException(this.getCurrentSectionPath(), "Error while writing into the save file.", exception);
            persistenceException.setDetails("storing persistent object " + iPersistentObject);
            throw persistenceException;
        }
        if (iPersistentSection != null) {
            this.closeSection();
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws PersistenceException {
        int n3 = 0;
        while (n3 < n2) {
            this.emitByte(byArray[n + n3]);
            ++n3;
        }
    }

    @Override
    public void write(boolean bl) throws PersistenceException {
        this.write8(bl ? 255 : 0);
    }

    @Override
    public void write(float f) throws PersistenceException {
        this.write(Float.floatToRawIntBits(f));
    }

    @Override
    public void write8(int n) throws PersistenceException {
        this.workBuff[0] = (byte)n;
        this.write(this.workBuff, 0, 1);
    }

    @Override
    public void write16(int n) throws PersistenceException {
        this.workBuff[0] = (byte)(n >>> 8);
        this.workBuff[1] = (byte)n;
        this.write(this.workBuff, 0, 2);
    }

    @Override
    public void write(int n) throws PersistenceException {
        this.workBuff[0] = (byte)(n >>> 24);
        this.workBuff[1] = (byte)(n >>> 16);
        this.workBuff[2] = (byte)(n >>> 8);
        this.workBuff[3] = (byte)n;
        this.write(this.workBuff, 0, 4);
    }

    @Override
    public void write(long l) throws PersistenceException {
        this.workBuff[0] = (byte)(l >>> 56);
        this.workBuff[1] = (byte)(l >>> 48);
        this.workBuff[2] = (byte)(l >>> 40);
        this.workBuff[3] = (byte)(l >>> 32);
        this.workBuff[4] = (byte)(l >>> 24);
        this.workBuff[5] = (byte)(l >>> 16);
        this.workBuff[6] = (byte)(l >>> 8);
        this.workBuff[7] = (byte)l;
        this.write(this.workBuff, 0, 8);
    }

    @Override
    public void write(InputStream inputStream) throws PersistenceException {
        try {
            int n;
            while (-1 != (n = inputStream.read())) {
                this.write8(n);
            }
        }
        catch (IOException iOException) {
            throw new PersistenceException(this.getCurrentSectionPath(), "Error while copying input stream into the save file.", iOException);
        }
    }

    @Override
    public void write(String string) throws PersistenceException {
        this.writeID(string);
        this.write8(0);
    }

    @Override
    public void writeID(String string) throws PersistenceException {
        if (string == null) {
            PersistenceException persistenceException = new PersistenceException(this.getCurrentSectionPath(), "Error while writing into the save file.");
            persistenceException.setDetails("writing null ID");
            throw persistenceException;
        }
        byte[] byArray = string.getBytes();
        this.write(byArray, 0, byArray.length);
    }
}

